/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.internal.core.storage;

import com.aptana.core.util.ArrayUtil;
import com.aptana.git.core.model.GitCommit;
import com.aptana.git.core.model.GitRef;
import com.aptana.git.core.model.GitRepository;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.ITag;
import org.eclipse.team.core.history.provider.FileRevision;

public class CommitFileRevision
extends FileRevision {
    private static final IPath DEV_NULL = Path.fromPortableString((String)"/dev/null");
    private GitCommit commit;
    private IPath path;

    public CommitFileRevision(GitCommit commit, IPath repoRelativePath) {
        this.commit = commit;
        this.path = repoRelativePath;
    }

    public IStorage getStorage(IProgressMonitor monitor) {
        return new IStorage(){

            public Object getAdapter(Class adapter) {
                return null;
            }

            public boolean isReadOnly() {
                return true;
            }

            public String getName() {
                return CommitFileRevision.this.getName();
            }

            public IPath getFullPath() {
                return CommitFileRevision.this.getFullPath();
            }

            public InputStream getContents() {
                if (CommitFileRevision.this.commit == null) {
                    return new ByteArrayInputStream(ArrayUtil.NO_BYTES);
                }
                IStatus result = CommitFileRevision.this.commit.repository().execute(GitRepository.ReadWrite.READ, "show", String.valueOf(CommitFileRevision.this.commit.sha()) + ":" + CommitFileRevision.this.path);
                try {
                    return new ByteArrayInputStream(result.getMessage().getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    return new ByteArrayInputStream(result.getMessage().getBytes());
                }
            }
        };
    }

    public String getName() {
        if (this.path.equals((Object)DEV_NULL)) {
            return DEV_NULL.toPortableString();
        }
        return this.path.toPortableString();
    }

    public boolean isPropertyMissing() {
        return false;
    }

    public IFileRevision withAllProperties(IProgressMonitor monitor) {
        return this;
    }

    public URI getURI() {
        if (this.commit == null) {
            return null;
        }
        IPath fullPath = this.getFullPath();
        if (fullPath == null) {
            return null;
        }
        return fullPath.toFile().toURI();
    }

    protected IPath getFullPath() {
        if (this.commit == null) {
            return null;
        }
        return this.commit.repository().workingDirectory().append(this.path);
    }

    public long getTimestamp() {
        if (this.commit == null) {
            return super.getTimestamp();
        }
        return this.commit.getTimestamp();
    }

    public boolean exists() {
        return !this.path.equals((Object)DEV_NULL);
    }

    public String getContentIdentifier() {
        if (this.commit == null) {
            return super.getContentIdentifier();
        }
        return this.commit.sha();
    }

    public String getAuthor() {
        if (this.commit == null) {
            return super.getAuthor();
        }
        return this.commit.getAuthor();
    }

    public String getComment() {
        if (this.commit == null) {
            return super.getComment();
        }
        return this.commit.getComment();
    }

    protected boolean isDescendantOf(IFileRevision revision) {
        if (!(revision instanceof CommitFileRevision)) {
            return false;
        }
        if (this.commit == null || !this.commit.hasParent()) {
            return false;
        }
        CommitFileRevision other = (CommitFileRevision)revision;
        return this.commit.parents().contains(other.commit.sha());
    }

    public boolean equals(Object obj) {
        if (obj instanceof CommitFileRevision) {
            CommitFileRevision other = (CommitFileRevision)((Object)obj);
            return this.path.equals((Object)other.path) && other.commit.equals(this.commit);
        }
        return false;
    }

    public int hashCode() {
        int hash = 31 * this.path.hashCode();
        return hash += this.commit == null ? 0 : this.commit.hashCode();
    }

    public ITag[] getTags() {
        if (this.commit == null || !this.commit.hasRefs()) {
            return super.getTags();
        }
        ArrayList<GitTag> tags = new ArrayList<GitTag>();
        for (GitRef ref : this.commit.getRefs()) {
            if (!ref.type().equals((Object)GitRef.TYPE.TAG)) continue;
            tags.add(new GitTag(ref.shortName()));
        }
        return tags.toArray(new ITag[tags.size()]);
    }

    private static class GitTag
    implements ITag {
        private String name;

        GitTag(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

